﻿' “组详细信息页”项模板在 http://go.microsoft.com/fwlink/?LinkId=234229 上提供

''' <summary>
''' 显示单个组的概述的页，包括组内各项
''' 的预览。
''' </summary>
Public NotInheritable Class GroupDetailPage
    Inherits Page

    ''' <summary>
    ''' NavigationHelper 在每页上用于协助导航和
    ''' 进程生命期管理
    ''' </summary>
    Public ReadOnly Property NavigationHelper As Common.NavigationHelper
        Get
            Return Me._navigationHelper
        End Get
    End Property
    Private _navigationHelper As Common.NavigationHelper

    ''' <summary>
    ''' 可将其更改为强类型视图模型。
    ''' </summary>
    Public ReadOnly Property DefaultViewModel As Common.ObservableDictionary
        Get
            Return Me._defaultViewModel
        End Get
    End Property
    Private _defaultViewModel As New Common.ObservableDictionary()


    Public Sub New()
        InitializeComponent()
        Me._navigationHelper = New Common.NavigationHelper(Me)
        AddHandler Me._navigationHelper.LoadState,
            AddressOf NavigationHelper_LoadState
    End Sub

    ''' <summary>
    ''' 使用在导航过程中传递的内容填充页。  在从以前的会话
    ''' 重新创建页时，也会提供任何已保存状态。
    ''' </summary>
    ''' <param name="sender">
    ''' 事件的来源; 通常为 <see cref="NavigationHelper"/>
    ''' </param>
    ''' <param name="e">事件数据，其中既提供在最初请求此页时传递给
    ''' <see cref="Frame.Navigate"/> 的导航参数，又提供
    ''' 此页在以前会话期间保留的状态的
    ''' 字典。 首次访问页面时，该状态将为 null。</param>
    Private Async Sub NavigationHelper_LoadState(sender As Object, e As Common.LoadStateEventArgs)
        ' TODO:  创建适用于问题域的合适数据模型以替换示例数据
        Dim group As Data.SampleDataGroup = Await Data.SampleDataSource.GetGroupAsync(DirectCast(e.NavigationParameter, String))
        Me.DefaultViewModel("Group") = group
        Me.DefaultViewModel("Items") = group.Items
    End Sub

    ''' <summary>
    ''' 在单击某个项时进行调用。
    ''' </summary>
    ''' <param name="sender">显示所单击项的 GridView (在应用程序处于对齐状态时
    ''' 为 ListView)。</param>
    ''' <param name="e">描述所单击项的事件数据。</param>
    Private Sub ItemView_ItemClick(sender As Object, e As ItemClickEventArgs)

        ' 导航至相应的目标页，并
        ' 通过将所需信息作为导航参数传入来配置新页
        Dim itemId As String = DirectCast(e.ClickedItem, Data.SampleDataItem).UniqueId
        Me.Frame.Navigate(GetType(ItemDetailPage), itemId)
    End Sub

#Region "NavigationHelper 注册"

    ''' 此部分中提供的方法只是用于使
    ''' NavigationHelper 可响应页面的导航方法。
    ''' 
    ''' 应将页面特有的逻辑放入用于
    ''' <see cref="Common.NavigationHelper.LoadState"/>
    ''' 和 <see cref="Common.NavigationHelper.SaveState"/> 的事件处理程序中。
    ''' 除了在会话期间保留的页面状态之外
    ''' LoadState 方法中还提供导航参数。

    Protected Overrides Sub OnNavigatedTo(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedTo(e)
    End Sub

    Protected Overrides Sub OnNavigatedFrom(e As NavigationEventArgs)
        _navigationHelper.OnNavigatedFrom(e)
    End Sub

#End Region
End Class
